package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  MaxResults,
  NextToken,
  NonEmptyString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStandardsControlsRequest(
    standardsSubscriptionArn: NonEmptyString,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest = {
    import DescribeStandardsControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
      .builder()
      .standardsSubscriptionArn(
        NonEmptyString.unwrap(standardsSubscriptionArn): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DescribeStandardsControlsRequest.ReadOnly =
    zio.aws.securityhub.model.DescribeStandardsControlsRequest
      .wrap(buildAwsValue())
}
object DescribeStandardsControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeStandardsControlsRequest =
      zio.aws.securityhub.model.DescribeStandardsControlsRequest(
        standardsSubscriptionArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def standardsSubscriptionArn: NonEmptyString
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getStandardsSubscriptionArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsSubscriptionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
  ) extends zio.aws.securityhub.model.DescribeStandardsControlsRequest.ReadOnly {
    override val standardsSubscriptionArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.standardsSubscriptionArn())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
  ): zio.aws.securityhub.model.DescribeStandardsControlsRequest.ReadOnly =
    new Wrapper(impl)
}
