package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdateFindingsUnprocessedFinding(
    findingIdentifier: zio.aws.securityhub.model.AwsSecurityFindingIdentifier,
    errorCode: NonEmptyString,
    errorMessage: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding = {
    import BatchUpdateFindingsUnprocessedFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding
      .builder()
      .findingIdentifier(findingIdentifier.buildAwsValue())
      .errorCode(NonEmptyString.unwrap(errorCode): java.lang.String)
      .errorMessage(NonEmptyString.unwrap(errorMessage): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding.ReadOnly =
    zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding
      .wrap(buildAwsValue())
}
object BatchUpdateFindingsUnprocessedFinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding =
      zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding(
        findingIdentifier.asEditable,
        errorCode,
        errorMessage
      )
    def findingIdentifier
        : zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    def errorCode: NonEmptyString
    def errorMessage: NonEmptyString
    def getFindingIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ] = ZIO.succeed(findingIdentifier)
    def getErrorCode: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding
  ) extends zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding.ReadOnly {
    override val findingIdentifier
        : zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly =
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier
        .wrap(impl.findingIdentifier())
    override val errorCode: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.errorCode())
    override val errorMessage: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.errorMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding
  ): zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding.ReadOnly =
    new Wrapper(impl)
}
