package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2RulesDetails(
    action: Optional[zio.aws.securityhub.model.AwsWafv2RulesActionDetails] =
      Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    overrideAction: Optional[NonEmptyString] = Optional.Absent,
    priority: Optional[Integer] = Optional.Absent,
    visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails = {
    import AwsWafv2RulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        overrideAction.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.overrideAction)
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(visibilityConfig.map(value => value.buildAwsValue()))(
        _.visibilityConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2RulesDetails.wrap(buildAwsValue())
}
object AwsWafv2RulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2RulesDetails =
      zio.aws.securityhub.model.AwsWafv2RulesDetails(
        action.map(value => value.asEditable),
        name.map(value => value),
        overrideAction.map(value => value),
        priority.map(value => value),
        visibilityConfig.map(value => value.asEditable)
      )
    def action: Optional[
      zio.aws.securityhub.model.AwsWafv2RulesActionDetails.ReadOnly
    ]
    def name: Optional[NonEmptyString]
    def overrideAction: Optional[NonEmptyString]
    def priority: Optional[Integer]
    def visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ]
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2RulesActionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("action", action)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getOverrideAction: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("overrideAction", overrideAction)
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getVisibilityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("visibilityConfig", visibilityConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails
  ) extends zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly {
    override val action: Optional[
      zio.aws.securityhub.model.AwsWafv2RulesActionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2RulesActionDetails.wrap(value)
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val overrideAction: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideAction())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val priority: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Integer)
    override val visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.visibilityConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails
  ): zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly = new Wrapper(impl)
}
