package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRuleGroupRulesDetails(
    action: Optional[
      zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails
    ] = Optional.Absent,
    priority: Optional[Integer] = Optional.Absent,
    ruleId: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails = {
    import AwsWafRuleGroupRulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRuleGroupRulesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRuleGroupRulesDetails.wrap(buildAwsValue())
}
object AwsWafRuleGroupRulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafRuleGroupRulesDetails =
      zio.aws.securityhub.model.AwsWafRuleGroupRulesDetails(
        action.map(value => value.asEditable),
        priority.map(value => value),
        ruleId.map(value => value),
        `type`.map(value => value)
      )
    def action: Optional[
      zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails.ReadOnly
    ]
    def priority: Optional[Integer]
    def ruleId: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("action", action)
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails
  ) extends zio.aws.securityhub.model.AwsWafRuleGroupRulesDetails.ReadOnly {
    override val action: Optional[
      zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails.wrap(value)
      )
    override val priority: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Integer)
    override val ruleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails
  ): zio.aws.securityhub.model.AwsWafRuleGroupRulesDetails.ReadOnly =
    new Wrapper(impl)
}
