package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketWebsiteConfigurationRoutingRuleRedirect(
    hostname: Optional[NonEmptyString] = Optional.Absent,
    httpRedirectCode: Optional[NonEmptyString] = Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent,
    replaceKeyPrefixWith: Optional[NonEmptyString] = Optional.Absent,
    replaceKeyWith: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect = {
    import AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
      .builder()
      .optionallyWith(
        hostname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        httpRedirectCode.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpRedirectCode)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        replaceKeyPrefixWith.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replaceKeyPrefixWith)
      .optionallyWith(
        replaceKeyWith.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replaceKeyWith)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
      .wrap(buildAwsValue())
}
object AwsS3BucketWebsiteConfigurationRoutingRuleRedirect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect =
      zio.aws.securityhub.model
        .AwsS3BucketWebsiteConfigurationRoutingRuleRedirect(
          hostname.map(value => value),
          httpRedirectCode.map(value => value),
          protocol.map(value => value),
          replaceKeyPrefixWith.map(value => value),
          replaceKeyWith.map(value => value)
        )
    def hostname: Optional[NonEmptyString]
    def httpRedirectCode: Optional[NonEmptyString]
    def protocol: Optional[NonEmptyString]
    def replaceKeyPrefixWith: Optional[NonEmptyString]
    def replaceKeyWith: Optional[NonEmptyString]
    def getHostname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getHttpRedirectCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpRedirectCode", httpRedirectCode)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getReplaceKeyPrefixWith: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("replaceKeyPrefixWith", replaceKeyPrefixWith)
    def getReplaceKeyWith: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("replaceKeyWith", replaceKeyWith)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
  ) extends zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly {
    override val hostname: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpRedirectCode: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpRedirectCode())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replaceKeyPrefixWith: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceKeyPrefixWith())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val replaceKeyWith: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceKeyWith())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
  ): zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly =
    new Wrapper(impl)
}
