package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketNotificationConfigurationFilter(
    s3KeyFilter: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationFilter = {
    import AwsS3BucketNotificationConfigurationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationFilter
      .builder()
      .optionallyWith(s3KeyFilter.map(value => value.buildAwsValue()))(
        _.s3KeyFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter
      .wrap(buildAwsValue())
}
object AwsS3BucketNotificationConfigurationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter =
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter(
        s3KeyFilter.map(value => value.asEditable)
      )
    def s3KeyFilter: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter.ReadOnly
    ]
    def getS3KeyFilter: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter.ReadOnly
    ] = AwsError.unwrapOptionField("s3KeyFilter", s3KeyFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationFilter
  ) extends zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter.ReadOnly {
    override val s3KeyFilter: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyFilter())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationFilter
  ): zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter.ReadOnly =
    new Wrapper(impl)
}
