package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterClusterNode(
    nodeRole: Optional[NonEmptyString] = Optional.Absent,
    privateIpAddress: Optional[NonEmptyString] = Optional.Absent,
    publicIpAddress: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode = {
    import AwsRedshiftClusterClusterNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
      .builder()
      .optionallyWith(
        nodeRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nodeRole)
      .optionallyWith(
        privateIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .optionallyWith(
        publicIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicIpAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterClusterNode
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterClusterNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterClusterNode =
      zio.aws.securityhub.model.AwsRedshiftClusterClusterNode(
        nodeRole.map(value => value),
        privateIpAddress.map(value => value),
        publicIpAddress.map(value => value)
      )
    def nodeRole: Optional[NonEmptyString]
    def privateIpAddress: Optional[NonEmptyString]
    def publicIpAddress: Optional[NonEmptyString]
    def getNodeRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nodeRole", nodeRole)
    def getPrivateIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPublicIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly {
    override val nodeRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeRole())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val privateIpAddress: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddress())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val publicIpAddress: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIpAddress())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
  ): zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly =
    new Wrapper(impl)
}
