package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsNetworkFirewallRuleGroupDetails(
    capacity: Optional[Integer] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    ruleGroup: Optional[zio.aws.securityhub.model.RuleGroupDetails] =
      Optional.Absent,
    ruleGroupArn: Optional[NonEmptyString] = Optional.Absent,
    ruleGroupId: Optional[NonEmptyString] = Optional.Absent,
    ruleGroupName: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails = {
    import AwsNetworkFirewallRuleGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
      .builder()
      .optionallyWith(capacity.map(value => value: java.lang.Integer))(
        _.capacity
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        ruleGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ruleGroupArn)
      .optionallyWith(
        ruleGroupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleGroupId)
      .optionallyWith(
        ruleGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ruleGroupName)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails
      .wrap(buildAwsValue())
}
object AwsNetworkFirewallRuleGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails =
      zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails(
        capacity.map(value => value),
        description.map(value => value),
        ruleGroup.map(value => value.asEditable),
        ruleGroupArn.map(value => value),
        ruleGroupId.map(value => value),
        ruleGroupName.map(value => value),
        `type`.map(value => value)
      )
    def capacity: Optional[Integer]
    def description: Optional[NonEmptyString]
    def ruleGroup: Optional[zio.aws.securityhub.model.RuleGroupDetails.ReadOnly]
    def ruleGroupArn: Optional[NonEmptyString]
    def ruleGroupId: Optional[NonEmptyString]
    def ruleGroupName: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def getCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getRuleGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getRuleGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getRuleGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleGroupId", ruleGroupId)
    def getRuleGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
  ) extends zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly {
    override val capacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => value: Integer)
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleGroup
        : Optional[zio.aws.securityhub.model.RuleGroupDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroup())
        .map(value => zio.aws.securityhub.model.RuleGroupDetails.wrap(value))
    override val ruleGroupArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleGroupId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleGroupName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
  ): zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly =
    new Wrapper(impl)
}
