package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionEnvironment(
    variables: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    error: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment = {
    import AwsLambdaFunctionEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
      .builder()
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.wrap(buildAwsValue())
}
object AwsLambdaFunctionEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionEnvironment =
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment(
        variables.map(value => value),
        error.map(value => value.asEditable)
      )
    def variables: Optional[Map[NonEmptyString, NonEmptyString]]
    def error: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly
    ]
    def getVariables: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("variables", variables)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly {
    override val variables: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val error: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
  ): zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly =
    new Wrapper(impl)
}
