package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticBeanstalkEnvironmentOptionSetting(
    namespace: Optional[NonEmptyString] = Optional.Absent,
    optionName: Optional[NonEmptyString] = Optional.Absent,
    resourceName: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting = {
    import AwsElasticBeanstalkEnvironmentOptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
      .builder()
      .optionallyWith(
        namespace.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        optionName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.optionName)
      .optionallyWith(
        resourceName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceName)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly =
    zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
      .wrap(buildAwsValue())
}
object AwsElasticBeanstalkEnvironmentOptionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting =
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting(
        namespace.map(value => value),
        optionName.map(value => value),
        resourceName.map(value => value),
        value.map(value => value)
      )
    def namespace: Optional[NonEmptyString]
    def optionName: Optional[NonEmptyString]
    def resourceName: Optional[NonEmptyString]
    def value: Optional[NonEmptyString]
    def getNamespace: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getOptionName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("optionName", optionName)
    def getResourceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
  ) extends zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly {
    override val namespace: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val optionName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.optionName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourceName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
  ): zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly =
    new Wrapper(impl)
}
