package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(
    capabilities: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
    ] = Optional.Absent,
    devices: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
    ]] = Optional.Absent,
    initProcessEnabled: Optional[Boolean] = Optional.Absent,
    maxSwap: Optional[Integer] = Optional.Absent,
    sharedMemorySize: Optional[Integer] = Optional.Absent,
    swappiness: Optional[Integer] = Optional.Absent,
    tmpfs: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
      .builder()
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        initProcessEnabled.map(value => value: java.lang.Boolean)
      )(_.initProcessEnabled)
      .optionallyWith(maxSwap.map(value => value: java.lang.Integer))(_.maxSwap)
      .optionallyWith(sharedMemorySize.map(value => value: java.lang.Integer))(
        _.sharedMemorySize
      )
      .optionallyWith(swappiness.map(value => value: java.lang.Integer))(
        _.swappiness
      )
      .optionallyWith(
        tmpfs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tmpfs)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(
          capabilities.map(value => value.asEditable),
          devices.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          initProcessEnabled.map(value => value),
          maxSwap.map(value => value),
          sharedMemorySize.map(value => value),
          swappiness.map(value => value),
          tmpfs.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def capabilities: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.ReadOnly
    ]
    def devices: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.ReadOnly
    ]]
    def initProcessEnabled: Optional[Boolean]
    def maxSwap: Optional[Integer]
    def sharedMemorySize: Optional[Integer]
    def swappiness: Optional[Integer]
    def tmpfs: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.ReadOnly
    ]]
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getInitProcessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("initProcessEnabled", initProcessEnabled)
    def getMaxSwap: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSwap", maxSwap)
    def getSharedMemorySize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sharedMemorySize", sharedMemorySize)
    def getSwappiness: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("swappiness", swappiness)
    def getTmpfs: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("tmpfs", tmpfs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly {
    override val capabilities: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capabilities())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
          .wrap(value)
      )
    override val devices: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.devices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
            .wrap(item)
        }.toList
      )
    override val initProcessEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.initProcessEnabled())
      .map(value => value: Boolean)
    override val maxSwap: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSwap())
      .map(value => value: Integer)
    override val sharedMemorySize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sharedMemorySize())
      .map(value => value: Integer)
    override val swappiness: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.swappiness())
      .map(value => value: Integer)
    override val tmpfs: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.tmpfs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly =
    new Wrapper(impl)
}
