package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpcPeeringConnectionDetails(
    accepterVpcInfo: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
    ] = Optional.Absent,
    expirationTime: Optional[NonEmptyString] = Optional.Absent,
    requesterVpcInfo: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
    ] = Optional.Absent,
    status: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails
    ] = Optional.Absent,
    vpcPeeringConnectionId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails = {
    import AwsEc2VpcPeeringConnectionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails
      .builder()
      .optionallyWith(accepterVpcInfo.map(value => value.buildAwsValue()))(
        _.accepterVpcInfo
      )
      .optionallyWith(
        expirationTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.expirationTime)
      .optionallyWith(requesterVpcInfo.map(value => value.buildAwsValue()))(
        _.requesterVpcInfo
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpcPeeringConnectionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionDetails =
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionDetails(
        accepterVpcInfo.map(value => value.asEditable),
        expirationTime.map(value => value),
        requesterVpcInfo.map(value => value.asEditable),
        status.map(value => value.asEditable),
        vpcPeeringConnectionId.map(value => value)
      )
    def accepterVpcInfo: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly
    ]
    def expirationTime: Optional[NonEmptyString]
    def requesterVpcInfo: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly
    ]
    def status: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails.ReadOnly
    ]
    def vpcPeeringConnectionId: Optional[NonEmptyString]
    def getAccepterVpcInfo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly
    ] = AwsError.unwrapOptionField("accepterVpcInfo", accepterVpcInfo)
    def getExpirationTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getRequesterVpcInfo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly
    ] = AwsError.unwrapOptionField("requesterVpcInfo", requesterVpcInfo)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionDetails.ReadOnly {
    override val accepterVpcInfo: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accepterVpcInfo())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
          .wrap(value)
      )
    override val expirationTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val requesterVpcInfo: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterVpcInfo())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
          .wrap(value)
      )
    override val status: Optional[
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails
          .wrap(value)
      )
    override val vpcPeeringConnectionId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails
  ): zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionDetails.ReadOnly =
    new Wrapper(impl)
}
