package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataPlacementDetails(
    affinity: Optional[NonEmptyString] = Optional.Absent,
    availabilityZone: Optional[NonEmptyString] = Optional.Absent,
    groupName: Optional[NonEmptyString] = Optional.Absent,
    hostId: Optional[NonEmptyString] = Optional.Absent,
    hostResourceGroupArn: Optional[NonEmptyString] = Optional.Absent,
    partitionNumber: Optional[Integer] = Optional.Absent,
    spreadDomain: Optional[NonEmptyString] = Optional.Absent,
    tenancy: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails = {
    import AwsEc2LaunchTemplateDataPlacementDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails
      .builder()
      .optionallyWith(
        affinity.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.affinity)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        hostId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostId)
      .optionallyWith(
        hostResourceGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostResourceGroupArn)
      .optionallyWith(partitionNumber.map(value => value: java.lang.Integer))(
        _.partitionNumber
      )
      .optionallyWith(
        spreadDomain.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.spreadDomain)
      .optionallyWith(
        tenancy.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.tenancy)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataPlacementDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails =
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails(
        affinity.map(value => value),
        availabilityZone.map(value => value),
        groupName.map(value => value),
        hostId.map(value => value),
        hostResourceGroupArn.map(value => value),
        partitionNumber.map(value => value),
        spreadDomain.map(value => value),
        tenancy.map(value => value)
      )
    def affinity: Optional[NonEmptyString]
    def availabilityZone: Optional[NonEmptyString]
    def groupName: Optional[NonEmptyString]
    def hostId: Optional[NonEmptyString]
    def hostResourceGroupArn: Optional[NonEmptyString]
    def partitionNumber: Optional[Integer]
    def spreadDomain: Optional[NonEmptyString]
    def tenancy: Optional[NonEmptyString]
    def getAffinity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("affinity", affinity)
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getHostId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getHostResourceGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostResourceGroupArn", hostResourceGroupArn)
    def getPartitionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionNumber", partitionNumber)
    def getSpreadDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("spreadDomain", spreadDomain)
    def getTenancy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tenancy", tenancy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails.ReadOnly {
    override val affinity: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.affinity())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val availabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val groupName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hostId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hostResourceGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostResourceGroupArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val partitionNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.partitionNumber())
      .map(value => value: Integer)
    override val spreadDomain: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.spreadDomain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tenancy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.tenancy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails.ReadOnly =
    new Wrapper(impl)
}
