package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails(
    ipv6Prefix: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails = {
    import AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
      .builder()
      .optionallyWith(
        ipv6Prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipv6Prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails(
          ipv6Prefix.map(value => value)
        )
    def ipv6Prefix: Optional[NonEmptyString]
    def getIpv6Prefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipv6Prefix", ipv6Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.ReadOnly {
    override val ipv6Prefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.ReadOnly =
    new Wrapper(impl)
}
