package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateOptions(
    certificateTransparencyLoggingPreference: Optional[NonEmptyString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateOptions = {
    import AwsCertificateManagerCertificateOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateOptions
      .builder()
      .optionallyWith(
        certificateTransparencyLoggingPreference.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateTransparencyLoggingPreference)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions =
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions(
        certificateTransparencyLoggingPreference.map(value => value)
      )
    def certificateTransparencyLoggingPreference: Optional[NonEmptyString]
    def getCertificateTransparencyLoggingPreference
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "certificateTransparencyLoggingPreference",
      certificateTransparencyLoggingPreference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateOptions
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly {
    override val certificateTransparencyLoggingPreference
        : Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateTransparencyLoggingPreference())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateOptions
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly =
    new Wrapper(impl)
}
