package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupRecoveryPointCalculatedLifecycleDetails(
    deleteAt: Optional[NonEmptyString] = Optional.Absent,
    moveToColdStorageAt: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails = {
    import AwsBackupRecoveryPointCalculatedLifecycleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails
      .builder()
      .optionallyWith(
        deleteAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.deleteAt)
      .optionallyWith(
        moveToColdStorageAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.moveToColdStorageAt)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails
      .wrap(buildAwsValue())
}
object AwsBackupRecoveryPointCalculatedLifecycleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails =
      zio.aws.securityhub.model
        .AwsBackupRecoveryPointCalculatedLifecycleDetails(
          deleteAt.map(value => value),
          moveToColdStorageAt.map(value => value)
        )
    def deleteAt: Optional[NonEmptyString]
    def moveToColdStorageAt: Optional[NonEmptyString]
    def getDeleteAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deleteAt", deleteAt)
    def getMoveToColdStorageAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("moveToColdStorageAt", moveToColdStorageAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails
  ) extends zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails.ReadOnly {
    override val deleteAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val moveToColdStorageAt: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moveToColdStorageAt())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails
  ): zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails.ReadOnly =
    new Wrapper(impl)
}
