package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayEndpointConfiguration(
    types: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayEndpointConfiguration = {
    import AwsApiGatewayEndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayEndpointConfiguration
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration
      .wrap(buildAwsValue())
}
object AwsApiGatewayEndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayEndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration =
      zio.aws.securityhub.model
        .AwsApiGatewayEndpointConfiguration(types.map(value => value))
    def types: Optional[List[NonEmptyString]]
    def getTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("types", types)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayEndpointConfiguration
  ) extends zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly {
    override val types: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayEndpointConfiguration
  ): zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly =
    new Wrapper(impl)
}
