package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StandardsManagedBy(
    company: Optional[NonEmptyString] = Optional.Absent,
    product: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsManagedBy = {
    import StandardsManagedBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsManagedBy
      .builder()
      .optionallyWith(
        company.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.company)
      .optionallyWith(
        product.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.product)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.StandardsManagedBy.ReadOnly =
    zio.aws.securityhub.model.StandardsManagedBy.wrap(buildAwsValue())
}
object StandardsManagedBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsManagedBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StandardsManagedBy =
      zio.aws.securityhub.model.StandardsManagedBy(
        company.map(value => value),
        product.map(value => value)
      )
    def company: Optional[NonEmptyString]
    def product: Optional[NonEmptyString]
    def getCompany: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("company", company)
    def getProduct: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("product", product)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsManagedBy
  ) extends zio.aws.securityhub.model.StandardsManagedBy.ReadOnly {
    override val company: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.company())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val product: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.product())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsManagedBy
  ): zio.aws.securityhub.model.StandardsManagedBy.ReadOnly = new Wrapper(impl)
}
