package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Page(
    pageNumber: Optional[Long] = Optional.Absent,
    lineRange: Optional[zio.aws.securityhub.model.Range] = Optional.Absent,
    offsetRange: Optional[zio.aws.securityhub.model.Range] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Page = {
    import Page.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Page
      .builder()
      .optionallyWith(pageNumber.map(value => value: java.lang.Long))(
        _.pageNumber
      )
      .optionallyWith(lineRange.map(value => value.buildAwsValue()))(
        _.lineRange
      )
      .optionallyWith(offsetRange.map(value => value.buildAwsValue()))(
        _.offsetRange
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Page.ReadOnly =
    zio.aws.securityhub.model.Page.wrap(buildAwsValue())
}
object Page {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.Page] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Page =
      zio.aws.securityhub.model.Page(
        pageNumber.map(value => value),
        lineRange.map(value => value.asEditable),
        offsetRange.map(value => value.asEditable)
      )
    def pageNumber: Optional[Long]
    def lineRange: Optional[zio.aws.securityhub.model.Range.ReadOnly]
    def offsetRange: Optional[zio.aws.securityhub.model.Range.ReadOnly]
    def getPageNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
    def getLineRange
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("lineRange", lineRange)
    def getOffsetRange
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("offsetRange", offsetRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Page
  ) extends zio.aws.securityhub.model.Page.ReadOnly {
    override val pageNumber: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.pageNumber())
      .map(value => value: Long)
    override val lineRange: Optional[zio.aws.securityhub.model.Range.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineRange())
        .map(value => zio.aws.securityhub.model.Range.wrap(value))
    override val offsetRange
        : Optional[zio.aws.securityhub.model.Range.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offsetRange())
        .map(value => zio.aws.securityhub.model.Range.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Page
  ): zio.aws.securityhub.model.Page.ReadOnly = new Wrapper(impl)
}
