package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpFilter(cidr: Optional[NonEmptyString] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.IpFilter = {
    import IpFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.IpFilter
      .builder()
      .optionallyWith(
        cidr.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidr)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.IpFilter.ReadOnly =
    zio.aws.securityhub.model.IpFilter.wrap(buildAwsValue())
}
object IpFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.IpFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.IpFilter =
      zio.aws.securityhub.model.IpFilter(cidr.map(value => value))
    def cidr: Optional[NonEmptyString]
    def getCidr: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidr", cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.IpFilter
  ) extends zio.aws.securityhub.model.IpFilter.ReadOnly {
    override val cidr: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.IpFilter
  ): zio.aws.securityhub.model.IpFilter.ReadOnly = new Wrapper(impl)
}
