package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteMembersResponse(
    unprocessedAccounts: Optional[Iterable[zio.aws.securityhub.model.Result]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse = {
    import DeleteMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse
      .builder()
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly =
    zio.aws.securityhub.model.DeleteMembersResponse.wrap(buildAwsValue())
}
object DeleteMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteMembersResponse =
      zio.aws.securityhub.model.DeleteMembersResponse(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]]
    def getUnprocessedAccounts
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Result.ReadOnly]] =
      AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse
  ) extends zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly {
    override val unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Result.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse
  ): zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
