package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFindingAggregatorRequest(
    findingAggregatorArn: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest = {
    import DeleteFindingAggregatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest
      .builder()
      .findingAggregatorArn(
        NonEmptyString.unwrap(findingAggregatorArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DeleteFindingAggregatorRequest.ReadOnly =
    zio.aws.securityhub.model.DeleteFindingAggregatorRequest
      .wrap(buildAwsValue())
}
object DeleteFindingAggregatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteFindingAggregatorRequest =
      zio.aws.securityhub.model
        .DeleteFindingAggregatorRequest(findingAggregatorArn)
    def findingAggregatorArn: NonEmptyString
    def getFindingAggregatorArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(findingAggregatorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest
  ) extends zio.aws.securityhub.model.DeleteFindingAggregatorRequest.ReadOnly {
    override val findingAggregatorArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.findingAggregatorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest
  ): zio.aws.securityhub.model.DeleteFindingAggregatorRequest.ReadOnly =
    new Wrapper(impl)
}
