package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateInsightRequest(
    name: NonEmptyString,
    filters: zio.aws.securityhub.model.AwsSecurityFindingFilters,
    groupByAttribute: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateInsightRequest = {
    import CreateInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateInsightRequest
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .filters(filters.buildAwsValue())
      .groupByAttribute(
        NonEmptyString.unwrap(groupByAttribute): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.CreateInsightRequest.ReadOnly =
    zio.aws.securityhub.model.CreateInsightRequest.wrap(buildAwsValue())
}
object CreateInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateInsightRequest =
      zio.aws.securityhub.model
        .CreateInsightRequest(name, filters.asEditable, groupByAttribute)
    def name: NonEmptyString
    def filters: zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    def groupByAttribute: NonEmptyString
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getFilters: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = ZIO.succeed(filters)
    def getGroupByAttribute: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(groupByAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateInsightRequest
  ) extends zio.aws.securityhub.model.CreateInsightRequest.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.name())
    override val filters
        : zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly =
      zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(impl.filters())
    override val groupByAttribute: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.groupByAttribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateInsightRequest
  ): zio.aws.securityhub.model.CreateInsightRequest.ReadOnly = new Wrapper(impl)
}
