package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchUpdateAutomationRulesResponse(
    processedAutomationRules: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    unprocessedAutomationRules: Optional[
      Iterable[zio.aws.securityhub.model.UnprocessedAutomationRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesResponse = {
    import BatchUpdateAutomationRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesResponse
      .builder()
      .optionallyWith(
        processedAutomationRules.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.processedAutomationRules)
      .optionallyWith(
        unprocessedAutomationRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAutomationRules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse.ReadOnly =
    zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse
      .wrap(buildAwsValue())
}
object BatchUpdateAutomationRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse =
      zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse(
        processedAutomationRules.map(value => value),
        unprocessedAutomationRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def processedAutomationRules: Optional[List[NonEmptyString]]
    def unprocessedAutomationRules: Optional[
      List[zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly]
    ]
    def getProcessedAutomationRules: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "processedAutomationRules",
        processedAutomationRules
      )
    def getUnprocessedAutomationRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedAutomationRules",
      unprocessedAutomationRules
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesResponse
  ) extends zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse.ReadOnly {
    override val processedAutomationRules: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processedAutomationRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val unprocessedAutomationRules: Optional[
      List[zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedAutomationRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.UnprocessedAutomationRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesResponse
  ): zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse.ReadOnly =
    new Wrapper(impl)
}
