package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdateAutomationRulesRequest(
    updateAutomationRulesRequestItems: Iterable[
      zio.aws.securityhub.model.UpdateAutomationRulesRequestItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest = {
    import BatchUpdateAutomationRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest
      .builder()
      .updateAutomationRulesRequestItems(updateAutomationRulesRequestItems.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchUpdateAutomationRulesRequest.ReadOnly =
    zio.aws.securityhub.model.BatchUpdateAutomationRulesRequest
      .wrap(buildAwsValue())
}
object BatchUpdateAutomationRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchUpdateAutomationRulesRequest =
      zio.aws.securityhub.model.BatchUpdateAutomationRulesRequest(
        updateAutomationRulesRequestItems.map { item =>
          item.asEditable
        }
      )
    def updateAutomationRulesRequestItems: List[
      zio.aws.securityhub.model.UpdateAutomationRulesRequestItem.ReadOnly
    ]
    def getUpdateAutomationRulesRequestItems: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.UpdateAutomationRulesRequestItem.ReadOnly
    ]] = ZIO.succeed(updateAutomationRulesRequestItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest
  ) extends zio.aws.securityhub.model.BatchUpdateAutomationRulesRequest.ReadOnly {
    override val updateAutomationRulesRequestItems: List[
      zio.aws.securityhub.model.UpdateAutomationRulesRequestItem.ReadOnly
    ] = impl
      .updateAutomationRulesRequestItems()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.UpdateAutomationRulesRequestItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest
  ): zio.aws.securityhub.model.BatchUpdateAutomationRulesRequest.ReadOnly =
    new Wrapper(impl)
}
