package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2RulesActionCountDetails(
    customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCountDetails = {
    import AwsWafv2RulesActionCountDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCountDetails
      .builder()
      .optionallyWith(
        customRequestHandling.map(value => value.buildAwsValue())
      )(_.customRequestHandling)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails
      .wrap(buildAwsValue())
}
object AwsWafv2RulesActionCountDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCountDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails =
      zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails(
        customRequestHandling.map(value => value.asEditable)
      )
    def customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ]
    def getCustomRequestHandling: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("customRequestHandling", customRequestHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCountDetails
  ) extends zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails.ReadOnly {
    override val customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customRequestHandling())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCountDetails
  ): zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails.ReadOnly =
    new Wrapper(impl)
}
