package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2RulesActionCaptchaDetails(
    customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCaptchaDetails = {
    import AwsWafv2RulesActionCaptchaDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCaptchaDetails
      .builder()
      .optionallyWith(
        customRequestHandling.map(value => value.buildAwsValue())
      )(_.customRequestHandling)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails
      .wrap(buildAwsValue())
}
object AwsWafv2RulesActionCaptchaDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCaptchaDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails =
      zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails(
        customRequestHandling.map(value => value.asEditable)
      )
    def customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ]
    def getCustomRequestHandling: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("customRequestHandling", customRequestHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCaptchaDetails
  ) extends zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails.ReadOnly {
    override val customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customRequestHandling())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionCaptchaDetails
  ): zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails.ReadOnly =
    new Wrapper(impl)
}
