package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2RuleGroupDetails(
    capacity: Optional[Long] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.securityhub.model.AwsWafv2RulesDetails]] =
      Optional.Absent,
    scope: Optional[NonEmptyString] = Optional.Absent,
    visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2RuleGroupDetails = {
    import AwsWafv2RuleGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RuleGroupDetails
      .builder()
      .optionallyWith(capacity.map(value => value: java.lang.Long))(_.capacity)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        scope.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scope)
      .optionallyWith(visibilityConfig.map(value => value.buildAwsValue()))(
        _.visibilityConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsWafv2RuleGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2RuleGroupDetails.wrap(buildAwsValue())
}
object AwsWafv2RuleGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RuleGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2RuleGroupDetails =
      zio.aws.securityhub.model.AwsWafv2RuleGroupDetails(
        capacity.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scope.map(value => value),
        visibilityConfig.map(value => value.asEditable)
      )
    def capacity: Optional[Long]
    def description: Optional[NonEmptyString]
    def id: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def rules: Optional[
      List[zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly]
    ]
    def scope: Optional[NonEmptyString]
    def visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ]
    def getCapacity: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getScope: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scope", scope)
    def getVisibilityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("visibilityConfig", visibilityConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RuleGroupDetails
  ) extends zio.aws.securityhub.model.AwsWafv2RuleGroupDetails.ReadOnly {
    override val capacity: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => value: Long)
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rules: Optional[
      List[zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafv2RulesDetails.wrap(item)
        }.toList
      )
    override val scope: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.scope())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.visibilityConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RuleGroupDetails
  ): zio.aws.securityhub.model.AwsWafv2RuleGroupDetails.ReadOnly = new Wrapper(
    impl
  )
}
