package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalWebAclRulesListOverrideActionDetails(
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails = {
    import AwsWafRegionalWebAclRulesListOverrideActionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails
      .wrap(buildAwsValue())
}
object AwsWafRegionalWebAclRulesListOverrideActionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails =
      zio.aws.securityhub.model
        .AwsWafRegionalWebAclRulesListOverrideActionDetails(
          `type`.map(value => value)
        )
    def `type`: Optional[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails
  ): zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListOverrideActionDetails.ReadOnly =
    new Wrapper(impl)
}
