package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSecurityFinding(
    schemaVersion: NonEmptyString,
    id: NonEmptyString,
    productArn: NonEmptyString,
    productName: Optional[NonEmptyString] = Optional.Absent,
    companyName: Optional[NonEmptyString] = Optional.Absent,
    region: Optional[NonEmptyString] = Optional.Absent,
    generatorId: NonEmptyString,
    awsAccountId: NonEmptyString,
    types: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    firstObservedAt: Optional[NonEmptyString] = Optional.Absent,
    lastObservedAt: Optional[NonEmptyString] = Optional.Absent,
    createdAt: NonEmptyString,
    updatedAt: NonEmptyString,
    severity: Optional[zio.aws.securityhub.model.Severity] = Optional.Absent,
    confidence: Optional[Integer] = Optional.Absent,
    criticality: Optional[Integer] = Optional.Absent,
    title: NonEmptyString,
    description: NonEmptyString,
    remediation: Optional[zio.aws.securityhub.model.Remediation] =
      Optional.Absent,
    sourceUrl: Optional[NonEmptyString] = Optional.Absent,
    productFields: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    userDefinedFields: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    malware: Optional[Iterable[zio.aws.securityhub.model.Malware]] =
      Optional.Absent,
    network: Optional[zio.aws.securityhub.model.Network] = Optional.Absent,
    networkPath: Optional[
      Iterable[zio.aws.securityhub.model.NetworkPathComponent]
    ] = Optional.Absent,
    process: Optional[zio.aws.securityhub.model.ProcessDetails] =
      Optional.Absent,
    threats: Optional[Iterable[zio.aws.securityhub.model.Threat]] =
      Optional.Absent,
    threatIntelIndicators: Optional[
      Iterable[zio.aws.securityhub.model.ThreatIntelIndicator]
    ] = Optional.Absent,
    resources: Iterable[zio.aws.securityhub.model.Resource],
    compliance: Optional[zio.aws.securityhub.model.Compliance] =
      Optional.Absent,
    verificationState: Optional[zio.aws.securityhub.model.VerificationState] =
      Optional.Absent,
    workflowState: Optional[zio.aws.securityhub.model.WorkflowState] =
      Optional.Absent,
    workflow: Optional[zio.aws.securityhub.model.Workflow] = Optional.Absent,
    recordState: Optional[zio.aws.securityhub.model.RecordState] =
      Optional.Absent,
    relatedFindings: Optional[
      Iterable[zio.aws.securityhub.model.RelatedFinding]
    ] = Optional.Absent,
    note: Optional[zio.aws.securityhub.model.Note] = Optional.Absent,
    vulnerabilities: Optional[
      Iterable[zio.aws.securityhub.model.Vulnerability]
    ] = Optional.Absent,
    patchSummary: Optional[zio.aws.securityhub.model.PatchSummary] =
      Optional.Absent,
    action: Optional[zio.aws.securityhub.model.Action] = Optional.Absent,
    findingProviderFields: Optional[
      zio.aws.securityhub.model.FindingProviderFields
    ] = Optional.Absent,
    sample: Optional[Boolean] = Optional.Absent,
    generatorDetails: Optional[zio.aws.securityhub.model.GeneratorDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSecurityFinding = {
    import AwsSecurityFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFinding
      .builder()
      .schemaVersion(NonEmptyString.unwrap(schemaVersion): java.lang.String)
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .productArn(NonEmptyString.unwrap(productArn): java.lang.String)
      .optionallyWith(
        productName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.productName)
      .optionallyWith(
        companyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.companyName)
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .generatorId(NonEmptyString.unwrap(generatorId): java.lang.String)
      .awsAccountId(NonEmptyString.unwrap(awsAccountId): java.lang.String)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        firstObservedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firstObservedAt)
      .optionallyWith(
        lastObservedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastObservedAt)
      .createdAt(NonEmptyString.unwrap(createdAt): java.lang.String)
      .updatedAt(NonEmptyString.unwrap(updatedAt): java.lang.String)
      .optionallyWith(severity.map(value => value.buildAwsValue()))(_.severity)
      .optionallyWith(confidence.map(value => value: java.lang.Integer))(
        _.confidence
      )
      .optionallyWith(criticality.map(value => value: java.lang.Integer))(
        _.criticality
      )
      .title(NonEmptyString.unwrap(title): java.lang.String)
      .description(NonEmptyString.unwrap(description): java.lang.String)
      .optionallyWith(remediation.map(value => value.buildAwsValue()))(
        _.remediation
      )
      .optionallyWith(
        sourceUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceUrl)
      .optionallyWith(
        productFields.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.productFields)
      .optionallyWith(
        userDefinedFields.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.userDefinedFields)
      .optionallyWith(
        malware.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malware)
      .optionallyWith(network.map(value => value.buildAwsValue()))(_.network)
      .optionallyWith(
        networkPath.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkPath)
      .optionallyWith(process.map(value => value.buildAwsValue()))(_.process)
      .optionallyWith(
        threats.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threats)
      .optionallyWith(
        threatIntelIndicators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicators)
      .resources(resources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(compliance.map(value => value.buildAwsValue()))(
        _.compliance
      )
      .optionallyWith(verificationState.map(value => value.unwrap))(
        _.verificationState
      )
      .optionallyWith(workflowState.map(value => value.unwrap))(_.workflowState)
      .optionallyWith(workflow.map(value => value.buildAwsValue()))(_.workflow)
      .optionallyWith(recordState.map(value => value.unwrap))(_.recordState)
      .optionallyWith(
        relatedFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindings)
      .optionallyWith(note.map(value => value.buildAwsValue()))(_.note)
      .optionallyWith(
        vulnerabilities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerabilities)
      .optionallyWith(patchSummary.map(value => value.buildAwsValue()))(
        _.patchSummary
      )
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        findingProviderFields.map(value => value.buildAwsValue())
      )(_.findingProviderFields)
      .optionallyWith(sample.map(value => value: java.lang.Boolean))(_.sample)
      .optionallyWith(generatorDetails.map(value => value.buildAwsValue()))(
        _.generatorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly =
    zio.aws.securityhub.model.AwsSecurityFinding.wrap(buildAwsValue())
}
object AwsSecurityFinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSecurityFinding =
      zio.aws.securityhub.model.AwsSecurityFinding(
        schemaVersion,
        id,
        productArn,
        productName.map(value => value),
        companyName.map(value => value),
        region.map(value => value),
        generatorId,
        awsAccountId,
        types.map(value => value),
        firstObservedAt.map(value => value),
        lastObservedAt.map(value => value),
        createdAt,
        updatedAt,
        severity.map(value => value.asEditable),
        confidence.map(value => value),
        criticality.map(value => value),
        title,
        description,
        remediation.map(value => value.asEditable),
        sourceUrl.map(value => value),
        productFields.map(value => value),
        userDefinedFields.map(value => value),
        malware.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        network.map(value => value.asEditable),
        networkPath.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        process.map(value => value.asEditable),
        threats.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resources.map { item =>
          item.asEditable
        },
        compliance.map(value => value.asEditable),
        verificationState.map(value => value),
        workflowState.map(value => value),
        workflow.map(value => value.asEditable),
        recordState.map(value => value),
        relatedFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        note.map(value => value.asEditable),
        vulnerabilities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        patchSummary.map(value => value.asEditable),
        action.map(value => value.asEditable),
        findingProviderFields.map(value => value.asEditable),
        sample.map(value => value),
        generatorDetails.map(value => value.asEditable)
      )
    def schemaVersion: NonEmptyString
    def id: NonEmptyString
    def productArn: NonEmptyString
    def productName: Optional[NonEmptyString]
    def companyName: Optional[NonEmptyString]
    def region: Optional[NonEmptyString]
    def generatorId: NonEmptyString
    def awsAccountId: NonEmptyString
    def types: Optional[List[NonEmptyString]]
    def firstObservedAt: Optional[NonEmptyString]
    def lastObservedAt: Optional[NonEmptyString]
    def createdAt: NonEmptyString
    def updatedAt: NonEmptyString
    def severity: Optional[zio.aws.securityhub.model.Severity.ReadOnly]
    def confidence: Optional[Integer]
    def criticality: Optional[Integer]
    def title: NonEmptyString
    def description: NonEmptyString
    def remediation: Optional[zio.aws.securityhub.model.Remediation.ReadOnly]
    def sourceUrl: Optional[NonEmptyString]
    def productFields: Optional[Map[NonEmptyString, NonEmptyString]]
    def userDefinedFields: Optional[Map[NonEmptyString, NonEmptyString]]
    def malware: Optional[List[zio.aws.securityhub.model.Malware.ReadOnly]]
    def network: Optional[zio.aws.securityhub.model.Network.ReadOnly]
    def networkPath: Optional[
      List[zio.aws.securityhub.model.NetworkPathComponent.ReadOnly]
    ]
    def process: Optional[zio.aws.securityhub.model.ProcessDetails.ReadOnly]
    def threats: Optional[List[zio.aws.securityhub.model.Threat.ReadOnly]]
    def threatIntelIndicators: Optional[
      List[zio.aws.securityhub.model.ThreatIntelIndicator.ReadOnly]
    ]
    def resources: List[zio.aws.securityhub.model.Resource.ReadOnly]
    def compliance: Optional[zio.aws.securityhub.model.Compliance.ReadOnly]
    def verificationState: Optional[zio.aws.securityhub.model.VerificationState]
    def workflowState: Optional[zio.aws.securityhub.model.WorkflowState]
    def workflow: Optional[zio.aws.securityhub.model.Workflow.ReadOnly]
    def recordState: Optional[zio.aws.securityhub.model.RecordState]
    def relatedFindings
        : Optional[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]]
    def note: Optional[zio.aws.securityhub.model.Note.ReadOnly]
    def vulnerabilities
        : Optional[List[zio.aws.securityhub.model.Vulnerability.ReadOnly]]
    def patchSummary: Optional[zio.aws.securityhub.model.PatchSummary.ReadOnly]
    def action: Optional[zio.aws.securityhub.model.Action.ReadOnly]
    def findingProviderFields
        : Optional[zio.aws.securityhub.model.FindingProviderFields.ReadOnly]
    def sample: Optional[Boolean]
    def generatorDetails
        : Optional[zio.aws.securityhub.model.GeneratorDetails.ReadOnly]
    def getSchemaVersion: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(schemaVersion)
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getProductArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(productArn)
    def getProductName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("productName", productName)
    def getCompanyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("companyName", companyName)
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
    def getGeneratorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(generatorId)
    def getAwsAccountId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(awsAccountId)
    def getTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("types", types)
    def getFirstObservedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firstObservedAt", firstObservedAt)
    def getLastObservedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastObservedAt", lastObservedAt)
    def getCreatedAt: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(updatedAt)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Severity.ReadOnly] =
      AwsError.unwrapOptionField("severity", severity)
    def getConfidence: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getCriticality: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("criticality", criticality)
    def getTitle: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(title)
    def getDescription: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(description)
    def getRemediation
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Remediation.ReadOnly] =
      AwsError.unwrapOptionField("remediation", remediation)
    def getSourceUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getProductFields
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("productFields", productFields)
    def getUserDefinedFields
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("userDefinedFields", userDefinedFields)
    def getMalware
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Malware.ReadOnly]] =
      AwsError.unwrapOptionField("malware", malware)
    def getNetwork
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Network.ReadOnly] =
      AwsError.unwrapOptionField("network", network)
    def getNetworkPath: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NetworkPathComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("networkPath", networkPath)
    def getProcess: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ProcessDetails.ReadOnly
    ] = AwsError.unwrapOptionField("process", process)
    def getThreats
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Threat.ReadOnly]] =
      AwsError.unwrapOptionField("threats", threats)
    def getThreatIntelIndicators: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.ThreatIntelIndicator.ReadOnly
    ]] =
      AwsError.unwrapOptionField("threatIntelIndicators", threatIntelIndicators)
    def getResources
        : ZIO[Any, Nothing, List[zio.aws.securityhub.model.Resource.ReadOnly]] =
      ZIO.succeed(resources)
    def getCompliance
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Compliance.ReadOnly] =
      AwsError.unwrapOptionField("compliance", compliance)
    def getVerificationState
        : ZIO[Any, AwsError, zio.aws.securityhub.model.VerificationState] =
      AwsError.unwrapOptionField("verificationState", verificationState)
    def getWorkflowState
        : ZIO[Any, AwsError, zio.aws.securityhub.model.WorkflowState] =
      AwsError.unwrapOptionField("workflowState", workflowState)
    def getWorkflow
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Workflow.ReadOnly] =
      AwsError.unwrapOptionField("workflow", workflow)
    def getRecordState
        : ZIO[Any, AwsError, zio.aws.securityhub.model.RecordState] =
      AwsError.unwrapOptionField("recordState", recordState)
    def getRelatedFindings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RelatedFinding.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedFindings", relatedFindings)
    def getNote: ZIO[Any, AwsError, zio.aws.securityhub.model.Note.ReadOnly] =
      AwsError.unwrapOptionField("note", note)
    def getVulnerabilities: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.Vulnerability.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerabilities", vulnerabilities)
    def getPatchSummary
        : ZIO[Any, AwsError, zio.aws.securityhub.model.PatchSummary.ReadOnly] =
      AwsError.unwrapOptionField("patchSummary", patchSummary)
    def getAction
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getFindingProviderFields: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.FindingProviderFields.ReadOnly
    ] =
      AwsError.unwrapOptionField("findingProviderFields", findingProviderFields)
    def getSample: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sample", sample)
    def getGeneratorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.GeneratorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("generatorDetails", generatorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFinding
  ) extends zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly {
    override val schemaVersion: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.schemaVersion())
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val productArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.productArn())
    override val productName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.productName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val companyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.companyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val region: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val generatorId: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.generatorId())
    override val awsAccountId: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.awsAccountId())
    override val types: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val firstObservedAt: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstObservedAt())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lastObservedAt: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastObservedAt())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val createdAt: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.createdAt())
    override val updatedAt: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.updatedAt())
    override val severity
        : Optional[zio.aws.securityhub.model.Severity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.securityhub.model.Severity.wrap(value))
    override val confidence: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => value: Integer)
    override val criticality: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.criticality())
      .map(value => value: Integer)
    override val title: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.title())
    override val description: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.description())
    override val remediation
        : Optional[zio.aws.securityhub.model.Remediation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediation())
        .map(value => zio.aws.securityhub.model.Remediation.wrap(value))
    override val sourceUrl: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val productFields: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productFields())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val userDefinedFields
        : Optional[Map[NonEmptyString, NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.userDefinedFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val malware
        : Optional[List[zio.aws.securityhub.model.Malware.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.malware())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Malware.wrap(item)
          }.toList
        )
    override val network: Optional[zio.aws.securityhub.model.Network.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.network())
        .map(value => zio.aws.securityhub.model.Network.wrap(value))
    override val networkPath: Optional[
      List[zio.aws.securityhub.model.NetworkPathComponent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkPath())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NetworkPathComponent.wrap(item)
        }.toList
      )
    override val process
        : Optional[zio.aws.securityhub.model.ProcessDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.process())
        .map(value => zio.aws.securityhub.model.ProcessDetails.wrap(value))
    override val threats
        : Optional[List[zio.aws.securityhub.model.Threat.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threats())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Threat.wrap(item)
          }.toList
        )
    override val threatIntelIndicators: Optional[
      List[zio.aws.securityhub.model.ThreatIntelIndicator.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.threatIntelIndicators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.ThreatIntelIndicator.wrap(item)
        }.toList
      )
    override val resources: List[zio.aws.securityhub.model.Resource.ReadOnly] =
      impl
        .resources()
        .asScala
        .map { item =>
          zio.aws.securityhub.model.Resource.wrap(item)
        }
        .toList
    override val compliance
        : Optional[zio.aws.securityhub.model.Compliance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliance())
        .map(value => zio.aws.securityhub.model.Compliance.wrap(value))
    override val verificationState
        : Optional[zio.aws.securityhub.model.VerificationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationState())
        .map(value => zio.aws.securityhub.model.VerificationState.wrap(value))
    override val workflowState
        : Optional[zio.aws.securityhub.model.WorkflowState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowState())
        .map(value => zio.aws.securityhub.model.WorkflowState.wrap(value))
    override val workflow
        : Optional[zio.aws.securityhub.model.Workflow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflow())
        .map(value => zio.aws.securityhub.model.Workflow.wrap(value))
    override val recordState: Optional[zio.aws.securityhub.model.RecordState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordState())
        .map(value => zio.aws.securityhub.model.RecordState.wrap(value))
    override val relatedFindings
        : Optional[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedFindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.RelatedFinding.wrap(item)
          }.toList
        )
    override val note: Optional[zio.aws.securityhub.model.Note.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.note())
        .map(value => zio.aws.securityhub.model.Note.wrap(value))
    override val vulnerabilities
        : Optional[List[zio.aws.securityhub.model.Vulnerability.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Vulnerability.wrap(item)
          }.toList
        )
    override val patchSummary
        : Optional[zio.aws.securityhub.model.PatchSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchSummary())
        .map(value => zio.aws.securityhub.model.PatchSummary.wrap(value))
    override val action: Optional[zio.aws.securityhub.model.Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.securityhub.model.Action.wrap(value))
    override val findingProviderFields
        : Optional[zio.aws.securityhub.model.FindingProviderFields.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingProviderFields())
        .map(value =>
          zio.aws.securityhub.model.FindingProviderFields.wrap(value)
        )
    override val sample: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sample())
      .map(value => value: Boolean)
    override val generatorDetails
        : Optional[zio.aws.securityhub.model.GeneratorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generatorDetails())
        .map(value => zio.aws.securityhub.model.GeneratorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFinding
  ): zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly = new Wrapper(impl)
}
