package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketWebsiteConfigurationRoutingRule(
    condition: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
    ] = Optional.Absent,
    redirect: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule = {
    import AwsS3BucketWebsiteConfigurationRoutingRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(redirect.map(value => value.buildAwsValue()))(_.redirect)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule
      .wrap(buildAwsValue())
}
object AwsS3BucketWebsiteConfigurationRoutingRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule =
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule(
        condition.map(value => value.asEditable),
        redirect.map(value => value.asEditable)
      )
    def condition: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly
    ]
    def redirect: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly
    ]
    def getCondition: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly
    ] = AwsError.unwrapOptionField("condition", condition)
    def getRedirect: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly
    ] = AwsError.unwrapOptionField("redirect", redirect)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule
  ) extends zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule.ReadOnly {
    override val condition: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.condition())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
          .wrap(value)
      )
    override val redirect: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redirect())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule
  ): zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule.ReadOnly =
    new Wrapper(impl)
}
