package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterRestoreStatus(
    currentRestoreRateInMegaBytesPerSecond: Optional[Double] = Optional.Absent,
    elapsedTimeInSeconds: Optional[Long] = Optional.Absent,
    estimatedTimeToCompletionInSeconds: Optional[Long] = Optional.Absent,
    progressInMegaBytes: Optional[Long] = Optional.Absent,
    snapshotSizeInMegaBytes: Optional[Long] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterRestoreStatus = {
    import AwsRedshiftClusterRestoreStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterRestoreStatus
      .builder()
      .optionallyWith(
        currentRestoreRateInMegaBytesPerSecond.map(value =>
          value: java.lang.Double
        )
      )(_.currentRestoreRateInMegaBytesPerSecond)
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .optionallyWith(
        estimatedTimeToCompletionInSeconds.map(value => value: java.lang.Long)
      )(_.estimatedTimeToCompletionInSeconds)
      .optionallyWith(progressInMegaBytes.map(value => value: java.lang.Long))(
        _.progressInMegaBytes
      )
      .optionallyWith(
        snapshotSizeInMegaBytes.map(value => value: java.lang.Long)
      )(_.snapshotSizeInMegaBytes)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterRestoreStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterRestoreStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus =
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus(
        currentRestoreRateInMegaBytesPerSecond.map(value => value),
        elapsedTimeInSeconds.map(value => value),
        estimatedTimeToCompletionInSeconds.map(value => value),
        progressInMegaBytes.map(value => value),
        snapshotSizeInMegaBytes.map(value => value),
        status.map(value => value)
      )
    def currentRestoreRateInMegaBytesPerSecond: Optional[Double]
    def elapsedTimeInSeconds: Optional[Long]
    def estimatedTimeToCompletionInSeconds: Optional[Long]
    def progressInMegaBytes: Optional[Long]
    def snapshotSizeInMegaBytes: Optional[Long]
    def status: Optional[NonEmptyString]
    def getCurrentRestoreRateInMegaBytesPerSecond: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "currentRestoreRateInMegaBytesPerSecond",
        currentRestoreRateInMegaBytesPerSecond
      )
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
    def getEstimatedTimeToCompletionInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeToCompletionInSeconds",
        estimatedTimeToCompletionInSeconds
      )
    def getProgressInMegaBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("progressInMegaBytes", progressInMegaBytes)
    def getSnapshotSizeInMegaBytes: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("snapshotSizeInMegaBytes", snapshotSizeInMegaBytes)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterRestoreStatus
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly {
    override val currentRestoreRateInMegaBytesPerSecond: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentRestoreRateInMegaBytesPerSecond())
        .map(value => value: Double)
    override val elapsedTimeInSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.elapsedTimeInSeconds())
      .map(value => value: Long)
    override val estimatedTimeToCompletionInSeconds: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeToCompletionInSeconds())
        .map(value => value: Long)
    override val progressInMegaBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.progressInMegaBytes())
      .map(value => value: Long)
    override val snapshotSizeInMegaBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotSizeInMegaBytes())
      .map(value => value: Long)
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterRestoreStatus
  ): zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly =
    new Wrapper(impl)
}
