package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterDetails(
    allowVersionUpgrade: Optional[Boolean] = Optional.Absent,
    automatedSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    availabilityZone: Optional[NonEmptyString] = Optional.Absent,
    clusterAvailabilityStatus: Optional[NonEmptyString] = Optional.Absent,
    clusterCreateTime: Optional[NonEmptyString] = Optional.Absent,
    clusterIdentifier: Optional[NonEmptyString] = Optional.Absent,
    clusterNodes: Optional[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterClusterNode]
    ] = Optional.Absent,
    clusterParameterGroups: Optional[Iterable[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup
    ]] = Optional.Absent,
    clusterPublicKey: Optional[NonEmptyString] = Optional.Absent,
    clusterRevisionNumber: Optional[NonEmptyString] = Optional.Absent,
    clusterSecurityGroups: Optional[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup]
    ] = Optional.Absent,
    clusterSnapshotCopyStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
    ] = Optional.Absent,
    clusterStatus: Optional[NonEmptyString] = Optional.Absent,
    clusterSubnetGroupName: Optional[NonEmptyString] = Optional.Absent,
    clusterVersion: Optional[NonEmptyString] = Optional.Absent,
    dbName: Optional[NonEmptyString] = Optional.Absent,
    deferredMaintenanceWindows: Optional[Iterable[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
    ]] = Optional.Absent,
    elasticIpStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus
    ] = Optional.Absent,
    elasticResizeNumberOfNodeOptions: Optional[NonEmptyString] =
      Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    endpoint: Optional[zio.aws.securityhub.model.AwsRedshiftClusterEndpoint] =
      Optional.Absent,
    enhancedVpcRouting: Optional[Boolean] = Optional.Absent,
    expectedNextSnapshotScheduleTime: Optional[NonEmptyString] =
      Optional.Absent,
    expectedNextSnapshotScheduleTimeStatus: Optional[NonEmptyString] =
      Optional.Absent,
    hsmStatus: Optional[zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus] =
      Optional.Absent,
    iamRoles: Optional[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterIamRole]
    ] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    maintenanceTrackName: Optional[NonEmptyString] = Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    masterUsername: Optional[NonEmptyString] = Optional.Absent,
    nextMaintenanceWindowStartTime: Optional[NonEmptyString] = Optional.Absent,
    nodeType: Optional[NonEmptyString] = Optional.Absent,
    numberOfNodes: Optional[Integer] = Optional.Absent,
    pendingActions: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues
    ] = Optional.Absent,
    preferredMaintenanceWindow: Optional[NonEmptyString] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    resizeInfo: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo
    ] = Optional.Absent,
    restoreStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus
    ] = Optional.Absent,
    snapshotScheduleIdentifier: Optional[NonEmptyString] = Optional.Absent,
    snapshotScheduleState: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup]
    ] = Optional.Absent,
    loggingStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails = {
    import AwsRedshiftClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
      .builder()
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        clusterAvailabilityStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterAvailabilityStatus)
      .optionallyWith(
        clusterCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterCreateTime)
      .optionallyWith(
        clusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterIdentifier)
      .optionallyWith(
        clusterNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterNodes)
      .optionallyWith(
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterGroups)
      .optionallyWith(
        clusterPublicKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterPublicKey)
      .optionallyWith(
        clusterRevisionNumber.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterRevisionNumber)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        clusterSnapshotCopyStatus.map(value => value.buildAwsValue())
      )(_.clusterSnapshotCopyStatus)
      .optionallyWith(
        clusterStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterStatus)
      .optionallyWith(
        clusterSubnetGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterSubnetGroupName)
      .optionallyWith(
        clusterVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterVersion)
      .optionallyWith(
        dbName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dbName)
      .optionallyWith(
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deferredMaintenanceWindows)
      .optionallyWith(elasticIpStatus.map(value => value.buildAwsValue()))(
        _.elasticIpStatus
      )
      .optionallyWith(
        elasticResizeNumberOfNodeOptions.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.elasticResizeNumberOfNodeOptions)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        expectedNextSnapshotScheduleTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.expectedNextSnapshotScheduleTime)
      .optionallyWith(
        expectedNextSnapshotScheduleTimeStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.expectedNextSnapshotScheduleTimeStatus)
      .optionallyWith(hsmStatus.map(value => value.buildAwsValue()))(
        _.hsmStatus
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        maintenanceTrackName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.maintenanceTrackName)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        nextMaintenanceWindowStartTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.nextMaintenanceWindowStartTime)
      .optionallyWith(
        nodeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nodeType)
      .optionallyWith(numberOfNodes.map(value => value: java.lang.Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        pendingActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.pendingActions)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(resizeInfo.map(value => value.buildAwsValue()))(
        _.resizeInfo
      )
      .optionallyWith(restoreStatus.map(value => value.buildAwsValue()))(
        _.restoreStatus
      )
      .optionallyWith(
        snapshotScheduleIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(
        snapshotScheduleState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotScheduleState)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(loggingStatus.map(value => value.buildAwsValue()))(
        _.loggingStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterDetails.wrap(buildAwsValue())
}
object AwsRedshiftClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterDetails =
      zio.aws.securityhub.model.AwsRedshiftClusterDetails(
        allowVersionUpgrade.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        availabilityZone.map(value => value),
        clusterAvailabilityStatus.map(value => value),
        clusterCreateTime.map(value => value),
        clusterIdentifier.map(value => value),
        clusterNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterPublicKey.map(value => value),
        clusterRevisionNumber.map(value => value),
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterSnapshotCopyStatus.map(value => value.asEditable),
        clusterStatus.map(value => value),
        clusterSubnetGroupName.map(value => value),
        clusterVersion.map(value => value),
        dbName.map(value => value),
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticIpStatus.map(value => value.asEditable),
        elasticResizeNumberOfNodeOptions.map(value => value),
        encrypted.map(value => value),
        endpoint.map(value => value.asEditable),
        enhancedVpcRouting.map(value => value),
        expectedNextSnapshotScheduleTime.map(value => value),
        expectedNextSnapshotScheduleTimeStatus.map(value => value),
        hsmStatus.map(value => value.asEditable),
        iamRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        maintenanceTrackName.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        masterUsername.map(value => value),
        nextMaintenanceWindowStartTime.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        pendingActions.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        resizeInfo.map(value => value.asEditable),
        restoreStatus.map(value => value.asEditable),
        snapshotScheduleIdentifier.map(value => value),
        snapshotScheduleState.map(value => value),
        vpcId.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loggingStatus.map(value => value.asEditable)
      )
    def allowVersionUpgrade: Optional[Boolean]
    def automatedSnapshotRetentionPeriod: Optional[Integer]
    def availabilityZone: Optional[NonEmptyString]
    def clusterAvailabilityStatus: Optional[NonEmptyString]
    def clusterCreateTime: Optional[NonEmptyString]
    def clusterIdentifier: Optional[NonEmptyString]
    def clusterNodes: Optional[
      List[zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly]
    ]
    def clusterParameterGroups: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly
    ]]
    def clusterPublicKey: Optional[NonEmptyString]
    def clusterRevisionNumber: Optional[NonEmptyString]
    def clusterSecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly
    ]]
    def clusterSnapshotCopyStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly
    ]
    def clusterStatus: Optional[NonEmptyString]
    def clusterSubnetGroupName: Optional[NonEmptyString]
    def clusterVersion: Optional[NonEmptyString]
    def dbName: Optional[NonEmptyString]
    def deferredMaintenanceWindows: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly
    ]]
    def elasticIpStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly
    ]
    def elasticResizeNumberOfNodeOptions: Optional[NonEmptyString]
    def encrypted: Optional[Boolean]
    def endpoint: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly
    ]
    def enhancedVpcRouting: Optional[Boolean]
    def expectedNextSnapshotScheduleTime: Optional[NonEmptyString]
    def expectedNextSnapshotScheduleTimeStatus: Optional[NonEmptyString]
    def hsmStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly
    ]
    def iamRoles: Optional[
      List[zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly]
    ]
    def kmsKeyId: Optional[NonEmptyString]
    def maintenanceTrackName: Optional[NonEmptyString]
    def manualSnapshotRetentionPeriod: Optional[Integer]
    def masterUsername: Optional[NonEmptyString]
    def nextMaintenanceWindowStartTime: Optional[NonEmptyString]
    def nodeType: Optional[NonEmptyString]
    def numberOfNodes: Optional[Integer]
    def pendingActions: Optional[List[NonEmptyString]]
    def pendingModifiedValues: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly
    ]
    def preferredMaintenanceWindow: Optional[NonEmptyString]
    def publiclyAccessible: Optional[Boolean]
    def resizeInfo: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly
    ]
    def restoreStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly
    ]
    def snapshotScheduleIdentifier: Optional[NonEmptyString]
    def snapshotScheduleState: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def vpcSecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly
    ]]
    def loggingStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus.ReadOnly
    ]
    def getAllowVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getAutomatedSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "automatedSnapshotRetentionPeriod",
        automatedSnapshotRetentionPeriod
      )
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getClusterAvailabilityStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "clusterAvailabilityStatus",
        clusterAvailabilityStatus
      )
    def getClusterCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getClusterNodes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterNodes", clusterNodes)
    def getClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterGroups",
      clusterParameterGroups
    )
    def getClusterPublicKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterPublicKey", clusterPublicKey)
    def getClusterRevisionNumber: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterRevisionNumber", clusterRevisionNumber)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getClusterSnapshotCopyStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clusterSnapshotCopyStatus",
      clusterSnapshotCopyStatus
    )
    def getClusterStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getClusterSubnetGroupName: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getClusterVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getDbName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDeferredMaintenanceWindows: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "deferredMaintenanceWindows",
      deferredMaintenanceWindows
    )
    def getElasticIpStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly
    ] = AwsError.unwrapOptionField("elasticIpStatus", elasticIpStatus)
    def getElasticResizeNumberOfNodeOptions
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "elasticResizeNumberOfNodeOptions",
      elasticResizeNumberOfNodeOptions
    )
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getExpectedNextSnapshotScheduleTime
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "expectedNextSnapshotScheduleTime",
      expectedNextSnapshotScheduleTime
    )
    def getExpectedNextSnapshotScheduleTimeStatus
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "expectedNextSnapshotScheduleTimeStatus",
      expectedNextSnapshotScheduleTimeStatus
    )
    def getHsmStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly
    ] = AwsError.unwrapOptionField("hsmStatus", hsmStatus)
    def getIamRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly
    ]] = AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getMaintenanceTrackName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getNextMaintenanceWindowStartTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "nextMaintenanceWindowStartTime",
        nextMaintenanceWindowStartTime
      )
    def getNodeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPendingActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("pendingActions", pendingActions)
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getResizeInfo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly
    ] = AwsError.unwrapOptionField("resizeInfo", resizeInfo)
    def getRestoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("restoreStatus", restoreStatus)
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getSnapshotScheduleState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotScheduleState", snapshotScheduleState)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getLoggingStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus.ReadOnly
    ] = AwsError.unwrapOptionField("loggingStatus", loggingStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly {
    override val allowVersionUpgrade: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowVersionUpgrade())
      .map(value => value: Boolean)
    override val automatedSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val availabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterAvailabilityStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterAvailabilityStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterCreateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterCreateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterNodes: Optional[
      List[zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterNodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.wrap(item)
        }.toList
      )
    override val clusterParameterGroups: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup
            .wrap(item)
        }.toList
      )
    override val clusterPublicKey: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterPublicKey())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterRevisionNumber: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterRevisionNumber())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterSecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup
            .wrap(item)
        }.toList
      )
    override val clusterSnapshotCopyStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterSnapshotCopyStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
          .wrap(value)
      )
    override val clusterStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterSubnetGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSubnetGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deferredMaintenanceWindows: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.deferredMaintenanceWindows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
            .wrap(item)
        }.toList
      )
    override val elasticIpStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticIpStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.wrap(value)
      )
    override val elasticResizeNumberOfNodeOptions: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticResizeNumberOfNodeOptions())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val endpoint: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.wrap(value)
      )
    override val enhancedVpcRouting: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedVpcRouting())
      .map(value => value: Boolean)
    override val expectedNextSnapshotScheduleTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedNextSnapshotScheduleTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val expectedNextSnapshotScheduleTimeStatus
        : Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.expectedNextSnapshotScheduleTimeStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hsmStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.wrap(value)
      )
    override val iamRoles: Optional[
      List[zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterIamRole.wrap(item)
        }.toList
      )
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val maintenanceTrackName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceTrackName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val manualSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val masterUsername: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUsername())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val nextMaintenanceWindowStartTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextMaintenanceWindowStartTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val nodeType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val numberOfNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfNodes())
      .map(value => value: Integer)
    override val pendingActions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val pendingModifiedValues: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues
          .wrap(value)
      )
    override val preferredMaintenanceWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val resizeInfo: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resizeInfo())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.wrap(value)
      )
    override val restoreStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.wrap(value)
      )
    override val snapshotScheduleIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotScheduleIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val snapshotScheduleState: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotScheduleState())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcSecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
            .wrap(item)
        }.toList
      )
    override val loggingStatus: Optional[
      zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
  ): zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly = new Wrapper(
    impl
  )
}
