package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterClusterSnapshotCopyStatus(
    destinationRegion: Optional[NonEmptyString] = Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    retentionPeriod: Optional[Integer] = Optional.Absent,
    snapshotCopyGrantName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus = {
    import AwsRedshiftClusterClusterSnapshotCopyStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
      .builder()
      .optionallyWith(
        destinationRegion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationRegion)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(retentionPeriod.map(value => value: java.lang.Integer))(
        _.retentionPeriod
      )
      .optionallyWith(
        snapshotCopyGrantName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotCopyGrantName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterClusterSnapshotCopyStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus =
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus(
        destinationRegion.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        retentionPeriod.map(value => value),
        snapshotCopyGrantName.map(value => value)
      )
    def destinationRegion: Optional[NonEmptyString]
    def manualSnapshotRetentionPeriod: Optional[Integer]
    def retentionPeriod: Optional[Integer]
    def snapshotCopyGrantName: Optional[NonEmptyString]
    def getDestinationRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationRegion", destinationRegion)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getSnapshotCopyGrantName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotCopyGrantName", snapshotCopyGrantName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly {
    override val destinationRegion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationRegion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val manualSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val retentionPeriod: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionPeriod())
      .map(value => value: Integer)
    override val snapshotCopyGrantName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotCopyGrantName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
  ): zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly =
    new Wrapper(impl)
}
