package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoDetails(
    encryptionInfo: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails
    ] = Optional.Absent,
    currentVersion: Optional[NonEmptyString] = Optional.Absent,
    numberOfBrokerNodes: Optional[Integer] = Optional.Absent,
    clusterName: Optional[NonEmptyString] = Optional.Absent,
    clientAuthentication: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoDetails = {
    import AwsMskClusterClusterInfoDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoDetails
      .builder()
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(
        currentVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.currentVersion)
      .optionallyWith(
        numberOfBrokerNodes.map(value => value: java.lang.Integer)
      )(_.numberOfBrokerNodes)
      .optionallyWith(
        clusterName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails =
      zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails(
        encryptionInfo.map(value => value.asEditable),
        currentVersion.map(value => value),
        numberOfBrokerNodes.map(value => value),
        clusterName.map(value => value),
        clientAuthentication.map(value => value.asEditable)
      )
    def encryptionInfo: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails.ReadOnly
    ]
    def currentVersion: Optional[NonEmptyString]
    def numberOfBrokerNodes: Optional[Integer]
    def clusterName: Optional[NonEmptyString]
    def clientAuthentication: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails.ReadOnly
    ]
    def getEncryptionInfo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getCurrentVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getNumberOfBrokerNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfBrokerNodes", numberOfBrokerNodes)
    def getClusterName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails.ReadOnly {
    override val encryptionInfo: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionInfo())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails
          .wrap(value)
      )
    override val currentVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val numberOfBrokerNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfBrokerNodes())
      .map(value => value: Integer)
    override val clusterName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clientAuthentication: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clientAuthentication())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails.ReadOnly =
    new Wrapper(impl)
}
