package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails = {
    import AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails(
          enabled.map(value => value)
        )
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.ReadOnly =
    new Wrapper(impl)
}
