package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails = {
    import AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails(
          enabled.map(value => value)
        )
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.ReadOnly =
    new Wrapper(impl)
}
