package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoClientAuthenticationSaslDetails(
    iam: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails
    ] = Optional.Absent,
    scram: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails = {
    import AwsMskClusterClusterInfoClientAuthenticationSaslDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails
      .builder()
      .optionallyWith(iam.map(value => value.buildAwsValue()))(_.iam)
      .optionallyWith(scram.map(value => value.buildAwsValue()))(_.scram)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoClientAuthenticationSaslDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoClientAuthenticationSaslDetails(
          iam.map(value => value.asEditable),
          scram.map(value => value.asEditable)
        )
    def iam: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.ReadOnly
    ]
    def scram: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.ReadOnly
    ]
    def getIam: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.ReadOnly
    ] = AwsError.unwrapOptionField("iam", iam)
    def getScram: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.ReadOnly
    ] = AwsError.unwrapOptionField("scram", scram)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails.ReadOnly {
    override val iam: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iam())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails
          .wrap(value)
      )
    override val scram: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scram())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails.ReadOnly =
    new Wrapper(impl)
}
