package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamPolicyDetails(
    attachmentCount: Optional[Integer] = Optional.Absent,
    createDate: Optional[NonEmptyString] = Optional.Absent,
    defaultVersionId: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    isAttachable: Optional[Boolean] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent,
    permissionsBoundaryUsageCount: Optional[Integer] = Optional.Absent,
    policyId: Optional[NonEmptyString] = Optional.Absent,
    policyName: Optional[NonEmptyString] = Optional.Absent,
    policyVersionList: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamPolicyVersion]
    ] = Optional.Absent,
    updateDate: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails = {
    import AwsIamPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
      .builder()
      .optionallyWith(attachmentCount.map(value => value: java.lang.Integer))(
        _.attachmentCount
      )
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        defaultVersionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(isAttachable.map(value => value: java.lang.Boolean))(
        _.isAttachable
      )
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        permissionsBoundaryUsageCount.map(value => value: java.lang.Integer)
      )(_.permissionsBoundaryUsageCount)
      .optionallyWith(
        policyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyVersionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyVersionList)
      .optionallyWith(
        updateDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.updateDate)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamPolicyDetails.wrap(buildAwsValue())
}
object AwsIamPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamPolicyDetails =
      zio.aws.securityhub.model.AwsIamPolicyDetails(
        attachmentCount.map(value => value),
        createDate.map(value => value),
        defaultVersionId.map(value => value),
        description.map(value => value),
        isAttachable.map(value => value),
        path.map(value => value),
        permissionsBoundaryUsageCount.map(value => value),
        policyId.map(value => value),
        policyName.map(value => value),
        policyVersionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateDate.map(value => value)
      )
    def attachmentCount: Optional[Integer]
    def createDate: Optional[NonEmptyString]
    def defaultVersionId: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def isAttachable: Optional[Boolean]
    def path: Optional[NonEmptyString]
    def permissionsBoundaryUsageCount: Optional[Integer]
    def policyId: Optional[NonEmptyString]
    def policyName: Optional[NonEmptyString]
    def policyVersionList
        : Optional[List[zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly]]
    def updateDate: Optional[NonEmptyString]
    def getAttachmentCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("attachmentCount", attachmentCount)
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getDefaultVersionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getIsAttachable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttachable", isAttachable)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getPermissionsBoundaryUsageCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "permissionsBoundaryUsageCount",
        permissionsBoundaryUsageCount
      )
    def getPolicyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyVersionList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("policyVersionList", policyVersionList)
    def getUpdateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updateDate", updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
  ) extends zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly {
    override val attachmentCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentCount())
      .map(value => value: Integer)
    override val createDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultVersionId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersionId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val isAttachable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAttachable())
      .map(value => value: Boolean)
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val permissionsBoundaryUsageCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsBoundaryUsageCount())
        .map(value => value: Integer)
    override val policyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policyVersionList: Optional[
      List[zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policyVersionList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamPolicyVersion.wrap(item)
        }.toList
      )
    override val updateDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.updateDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
  ): zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly = new Wrapper(impl)
}
