package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamAttachedManagedPolicy(
    policyName: Optional[NonEmptyString] = Optional.Absent,
    policyArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy = {
    import AwsIamAttachedManagedPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy
      .builder()
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly =
    zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.wrap(buildAwsValue())
}
object AwsIamAttachedManagedPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamAttachedManagedPolicy =
      zio.aws.securityhub.model.AwsIamAttachedManagedPolicy(
        policyName.map(value => value),
        policyArn.map(value => value)
      )
    def policyName: Optional[NonEmptyString]
    def policyArn: Optional[NonEmptyString]
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyArn", policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy
  ) extends zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly {
    override val policyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policyArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy
  ): zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly =
    new Wrapper(impl)
}
