package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEventbusDetails(
    arn: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    policy: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEventbusDetails = {
    import AwsEventsEventbusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEventbusDetails
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        policy.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEventsEventbusDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEventbusDetails.wrap(buildAwsValue())
}
object AwsEventsEventbusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEventbusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEventsEventbusDetails =
      zio.aws.securityhub.model.AwsEventsEventbusDetails(
        arn.map(value => value),
        name.map(value => value),
        policy.map(value => value)
      )
    def arn: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def policy: Optional[NonEmptyString]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEventbusDetails
  ) extends zio.aws.securityhub.model.AwsEventsEventbusDetails.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEventbusDetails
  ): zio.aws.securityhub.model.AwsEventsEventbusDetails.ReadOnly = new Wrapper(
    impl
  )
}
