package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails(
    route: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails = {
    import AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
      .builder()
      .optionallyWith(
        route.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.route)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
      .wrap(buildAwsValue())
}
object AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails =
      zio.aws.securityhub.model
        .AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails(
          route.map(value => value)
        )
    def route: Optional[NonEmptyString]
    def getRoute: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("route", route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
  ) extends zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.ReadOnly {
    override val route: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.route())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
  ): zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.ReadOnly =
    new Wrapper(impl)
}
