package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEndpointRoutingConfigFailoverConfigDetails(
    primary: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
    ] = Optional.Absent,
    secondary: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails = {
    import AwsEventsEndpointRoutingConfigFailoverConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails
      .builder()
      .optionallyWith(primary.map(value => value.buildAwsValue()))(_.primary)
      .optionallyWith(secondary.map(value => value.buildAwsValue()))(
        _.secondary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails
      .wrap(buildAwsValue())
}
object AwsEventsEndpointRoutingConfigFailoverConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails =
      zio.aws.securityhub.model
        .AwsEventsEndpointRoutingConfigFailoverConfigDetails(
          primary.map(value => value.asEditable),
          secondary.map(value => value.asEditable)
        )
    def primary: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.ReadOnly
    ]
    def secondary: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.ReadOnly
    ]
    def getPrimary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.ReadOnly
    ] = AwsError.unwrapOptionField("primary", primary)
    def getSecondary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.ReadOnly
    ] = AwsError.unwrapOptionField("secondary", secondary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails
  ) extends zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails.ReadOnly {
    override val primary: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.primary())
      .map(value =>
        zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
          .wrap(value)
      )
    override val secondary: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secondary())
      .map(value =>
        zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails
  ): zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails.ReadOnly =
    new Wrapper(impl)
}
