package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEndpointEventBusesDetails(
    eventBusArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails = {
    import AwsEventsEndpointEventBusesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails
      .builder()
      .optionallyWith(
        eventBusArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.eventBusArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails
      .wrap(buildAwsValue())
}
object AwsEventsEndpointEventBusesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails =
      zio.aws.securityhub.model
        .AwsEventsEndpointEventBusesDetails(eventBusArn.map(value => value))
    def eventBusArn: Optional[NonEmptyString]
    def getEventBusArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("eventBusArn", eventBusArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails
  ) extends zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails.ReadOnly {
    override val eventBusArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBusArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails
  ): zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails.ReadOnly =
    new Wrapper(impl)
}
