package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbAppCookieStickinessPolicy(
    cookieName: Optional[NonEmptyString] = Optional.Absent,
    policyName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbAppCookieStickinessPolicy = {
    import AwsElbAppCookieStickinessPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbAppCookieStickinessPolicy
      .builder()
      .optionallyWith(
        cookieName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cookieName)
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly =
    zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy
      .wrap(buildAwsValue())
}
object AwsElbAppCookieStickinessPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbAppCookieStickinessPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy =
      zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy(
        cookieName.map(value => value),
        policyName.map(value => value)
      )
    def cookieName: Optional[NonEmptyString]
    def policyName: Optional[NonEmptyString]
    def getCookieName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cookieName", cookieName)
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbAppCookieStickinessPolicy
  ) extends zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly {
    override val cookieName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cookieName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbAppCookieStickinessPolicy
  ): zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly =
    new Wrapper(impl)
}
