package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEksClusterDetails(
    arn: Optional[NonEmptyString] = Optional.Absent,
    certificateAuthorityData: Optional[NonEmptyString] = Optional.Absent,
    clusterStatus: Optional[NonEmptyString] = Optional.Absent,
    endpoint: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    resourcesVpcConfig: Optional[
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
    ] = Optional.Absent,
    roleArn: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    logging: Optional[zio.aws.securityhub.model.AwsEksClusterLoggingDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails = {
    import AwsEksClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        certificateAuthorityData.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityData)
      .optionallyWith(
        clusterStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterStatus)
      .optionallyWith(
        endpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(resourcesVpcConfig.map(value => value.buildAwsValue()))(
        _.resourcesVpcConfig
      )
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEksClusterDetails.wrap(buildAwsValue())
}
object AwsEksClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEksClusterDetails =
      zio.aws.securityhub.model.AwsEksClusterDetails(
        arn.map(value => value),
        certificateAuthorityData.map(value => value),
        clusterStatus.map(value => value),
        endpoint.map(value => value),
        name.map(value => value),
        resourcesVpcConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        version.map(value => value),
        logging.map(value => value.asEditable)
      )
    def arn: Optional[NonEmptyString]
    def certificateAuthorityData: Optional[NonEmptyString]
    def clusterStatus: Optional[NonEmptyString]
    def endpoint: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def resourcesVpcConfig: Optional[
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly
    ]
    def roleArn: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def logging: Optional[
      zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCertificateAuthorityData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "certificateAuthorityData",
        certificateAuthorityData
      )
    def getClusterStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getResourcesVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("resourcesVpcConfig", resourcesVpcConfig)
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getLogging: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logging", logging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
  ) extends zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val certificateAuthorityData: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthorityData())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoint: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourcesVpcConfig: Optional[
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcesVpcConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
          .wrap(value)
      )
    override val roleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logging: Optional[
      zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logging())
      .map(value =>
        zio.aws.securityhub.model.AwsEksClusterLoggingDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
  ): zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly = new Wrapper(impl)
}
