package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(
    command: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    interval: Optional[Integer] = Optional.Absent,
    retries: Optional[Integer] = Optional.Absent,
    startPeriod: Optional[Integer] = Optional.Absent,
    timeout: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
      .builder()
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(interval.map(value => value: java.lang.Integer))(
        _.interval
      )
      .optionallyWith(retries.map(value => value: java.lang.Integer))(_.retries)
      .optionallyWith(startPeriod.map(value => value: java.lang.Integer))(
        _.startPeriod
      )
      .optionallyWith(timeout.map(value => value: java.lang.Integer))(_.timeout)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(
          command.map(value => value),
          interval.map(value => value),
          retries.map(value => value),
          startPeriod.map(value => value),
          timeout.map(value => value)
        )
    def command: Optional[List[NonEmptyString]]
    def interval: Optional[Integer]
    def retries: Optional[Integer]
    def startPeriod: Optional[Integer]
    def timeout: Optional[Integer]
    def getCommand: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("command", command)
    def getInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("interval", interval)
    def getRetries: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("retries", retries)
    def getStartPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("startPeriod", startPeriod)
    def getTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly {
    override val command: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val interval: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => value: Integer)
    override val retries: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.retries())
      .map(value => value: Integer)
    override val startPeriod: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.startPeriod())
      .map(value => value: Integer)
    override val timeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly =
    new Wrapper(impl)
}
