package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsDetails(
    command: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    cpu: Optional[Integer] = Optional.Absent,
    dependsOn: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
    ]] = Optional.Absent,
    disableNetworking: Optional[Boolean] = Optional.Absent,
    dnsSearchDomains: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    dnsServers: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    dockerLabels: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    dockerSecurityOptions: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    entryPoint: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    environment: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
    ]] = Optional.Absent,
    environmentFiles: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
    ]] = Optional.Absent,
    essential: Optional[Boolean] = Optional.Absent,
    extraHosts: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
    ]] = Optional.Absent,
    firelensConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
    ] = Optional.Absent,
    healthCheck: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
    ] = Optional.Absent,
    hostname: Optional[NonEmptyString] = Optional.Absent,
    image: Optional[NonEmptyString] = Optional.Absent,
    interactive: Optional[Boolean] = Optional.Absent,
    links: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    linuxParameters: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
    ] = Optional.Absent,
    logConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
    ] = Optional.Absent,
    memory: Optional[Integer] = Optional.Absent,
    memoryReservation: Optional[Integer] = Optional.Absent,
    mountPoints: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
    ]] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    portMappings: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
    ]] = Optional.Absent,
    privileged: Optional[Boolean] = Optional.Absent,
    pseudoTerminal: Optional[Boolean] = Optional.Absent,
    readonlyRootFilesystem: Optional[Boolean] = Optional.Absent,
    repositoryCredentials: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
    ] = Optional.Absent,
    resourceRequirements: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
    ]] = Optional.Absent,
    secrets: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
    ]] = Optional.Absent,
    startTimeout: Optional[Integer] = Optional.Absent,
    stopTimeout: Optional[Integer] = Optional.Absent,
    systemControls: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
    ]] = Optional.Absent,
    ulimits: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
    ]] = Optional.Absent,
    user: Optional[NonEmptyString] = Optional.Absent,
    volumesFrom: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
    ]] = Optional.Absent,
    workingDirectory: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
      .builder()
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(cpu.map(value => value: java.lang.Integer))(_.cpu)
      .optionallyWith(
        dependsOn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependsOn)
      .optionallyWith(disableNetworking.map(value => value: java.lang.Boolean))(
        _.disableNetworking
      )
      .optionallyWith(
        dnsSearchDomains.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsSearchDomains)
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(
        dockerLabels.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dockerLabels)
      .optionallyWith(
        dockerSecurityOptions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dockerSecurityOptions)
      .optionallyWith(
        entryPoint.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entryPoint)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        environmentFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentFiles)
      .optionallyWith(essential.map(value => value: java.lang.Boolean))(
        _.essential
      )
      .optionallyWith(
        extraHosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extraHosts)
      .optionallyWith(
        firelensConfiguration.map(value => value.buildAwsValue())
      )(_.firelensConfiguration)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(
        hostname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        image.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.image)
      .optionallyWith(interactive.map(value => value: java.lang.Boolean))(
        _.interactive
      )
      .optionallyWith(
        links.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.links)
      .optionallyWith(linuxParameters.map(value => value.buildAwsValue()))(
        _.linuxParameters
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(memory.map(value => value: java.lang.Integer))(_.memory)
      .optionallyWith(memoryReservation.map(value => value: java.lang.Integer))(
        _.memoryReservation
      )
      .optionallyWith(
        mountPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountPoints)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        portMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portMappings)
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .optionallyWith(pseudoTerminal.map(value => value: java.lang.Boolean))(
        _.pseudoTerminal
      )
      .optionallyWith(
        readonlyRootFilesystem.map(value => value: java.lang.Boolean)
      )(_.readonlyRootFilesystem)
      .optionallyWith(
        repositoryCredentials.map(value => value.buildAwsValue())
      )(_.repositoryCredentials)
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .optionallyWith(
        secrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secrets)
      .optionallyWith(startTimeout.map(value => value: java.lang.Integer))(
        _.startTimeout
      )
      .optionallyWith(stopTimeout.map(value => value: java.lang.Integer))(
        _.stopTimeout
      )
      .optionallyWith(
        systemControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.systemControls)
      .optionallyWith(
        ulimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ulimits)
      .optionallyWith(
        user.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        volumesFrom.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumesFrom)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails(
        command.map(value => value),
        cpu.map(value => value),
        dependsOn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableNetworking.map(value => value),
        dnsSearchDomains.map(value => value),
        dnsServers.map(value => value),
        dockerLabels.map(value => value),
        dockerSecurityOptions.map(value => value),
        entryPoint.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        essential.map(value => value),
        extraHosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firelensConfiguration.map(value => value.asEditable),
        healthCheck.map(value => value.asEditable),
        hostname.map(value => value),
        image.map(value => value),
        interactive.map(value => value),
        links.map(value => value),
        linuxParameters.map(value => value.asEditable),
        logConfiguration.map(value => value.asEditable),
        memory.map(value => value),
        memoryReservation.map(value => value),
        mountPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        portMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privileged.map(value => value),
        pseudoTerminal.map(value => value),
        readonlyRootFilesystem.map(value => value),
        repositoryCredentials.map(value => value.asEditable),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTimeout.map(value => value),
        stopTimeout.map(value => value),
        systemControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ulimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        user.map(value => value),
        volumesFrom.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workingDirectory.map(value => value)
      )
    def command: Optional[List[NonEmptyString]]
    def cpu: Optional[Integer]
    def dependsOn: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly
    ]]
    def disableNetworking: Optional[Boolean]
    def dnsSearchDomains: Optional[List[NonEmptyString]]
    def dnsServers: Optional[List[NonEmptyString]]
    def dockerLabels: Optional[Map[NonEmptyString, NonEmptyString]]
    def dockerSecurityOptions: Optional[List[NonEmptyString]]
    def entryPoint: Optional[List[NonEmptyString]]
    def environment: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.ReadOnly
    ]]
    def environmentFiles: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.ReadOnly
    ]]
    def essential: Optional[Boolean]
    def extraHosts: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly
    ]]
    def firelensConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly
    ]
    def healthCheck: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly
    ]
    def hostname: Optional[NonEmptyString]
    def image: Optional[NonEmptyString]
    def interactive: Optional[Boolean]
    def links: Optional[List[NonEmptyString]]
    def linuxParameters: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly
    ]
    def logConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly
    ]
    def memory: Optional[Integer]
    def memoryReservation: Optional[Integer]
    def mountPoints: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly
    ]]
    def name: Optional[NonEmptyString]
    def portMappings: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly
    ]]
    def privileged: Optional[Boolean]
    def pseudoTerminal: Optional[Boolean]
    def readonlyRootFilesystem: Optional[Boolean]
    def repositoryCredentials: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly
    ]
    def resourceRequirements: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly
    ]]
    def secrets: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.ReadOnly
    ]]
    def startTimeout: Optional[Integer]
    def stopTimeout: Optional[Integer]
    def systemControls: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.ReadOnly
    ]]
    def ulimits: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly
    ]]
    def user: Optional[NonEmptyString]
    def volumesFrom: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly
    ]]
    def workingDirectory: Optional[NonEmptyString]
    def getCommand: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("command", command)
    def getCpu: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getDependsOn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("dependsOn", dependsOn)
    def getDisableNetworking: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableNetworking", disableNetworking)
    def getDnsSearchDomains: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dnsSearchDomains", dnsSearchDomains)
    def getDnsServers: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getDockerLabels
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("dockerLabels", dockerLabels)
    def getDockerSecurityOptions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dockerSecurityOptions", dockerSecurityOptions)
    def getEntryPoint: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getEnvironment: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getEnvironmentFiles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentFiles", environmentFiles)
    def getEssential: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("essential", essential)
    def getExtraHosts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("extraHosts", extraHosts)
    def getFirelensConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("firelensConfiguration", firelensConfiguration)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getHostname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("image", image)
    def getInteractive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("interactive", interactive)
    def getLinks: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("links", links)
    def getLinuxParameters: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly
    ] = AwsError.unwrapOptionField("linuxParameters", linuxParameters)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getMemory: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getMountPoints: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("mountPoints", mountPoints)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPortMappings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("portMappings", portMappings)
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
    def getPseudoTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pseudoTerminal", pseudoTerminal)
    def getReadonlyRootFilesystem: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("readonlyRootFilesystem", readonlyRootFilesystem)
    def getRepositoryCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryCredentials", repositoryCredentials)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
    def getSecrets: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("secrets", secrets)
    def getStartTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("startTimeout", startTimeout)
    def getStopTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stopTimeout", stopTimeout)
    def getSystemControls: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("systemControls", systemControls)
    def getUlimits: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("ulimits", ulimits)
    def getUser: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("user", user)
    def getVolumesFrom: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("volumesFrom", volumesFrom)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly {
    override val command: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val cpu: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: Integer)
    override val dependsOn: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.dependsOn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
            .wrap(item)
        }.toList
      )
    override val disableNetworking: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disableNetworking())
      .map(value => value: Boolean)
    override val dnsSearchDomains: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsSearchDomains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val dnsServers: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsServers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val dockerLabels: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dockerLabels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val dockerSecurityOptions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dockerSecurityOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val entryPoint: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entryPoint())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val environment: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.environment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
            .wrap(item)
        }.toList
      )
    override val environmentFiles: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentFiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
            .wrap(item)
        }.toList
      )
    override val essential: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.essential())
      .map(value => value: Boolean)
    override val extraHosts: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.extraHosts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
            .wrap(item)
        }.toList
      )
    override val firelensConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firelensConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
          .wrap(value)
      )
    override val healthCheck: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheck())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
          .wrap(value)
      )
    override val hostname: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val image: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val interactive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.interactive())
      .map(value => value: Boolean)
    override val links: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.links())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val linuxParameters: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.linuxParameters())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
          .wrap(value)
      )
    override val logConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
          .wrap(value)
      )
    override val memory: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: Integer)
    override val memoryReservation: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryReservation())
      .map(value => value: Integer)
    override val mountPoints: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.mountPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
            .wrap(item)
        }.toList
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val portMappings: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.portMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
            .wrap(item)
        }.toList
      )
    override val privileged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: Boolean)
    override val pseudoTerminal: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.pseudoTerminal())
      .map(value => value: Boolean)
    override val readonlyRootFilesystem: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readonlyRootFilesystem())
        .map(value => value: Boolean)
    override val repositoryCredentials: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryCredentials())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
          .wrap(value)
      )
    override val resourceRequirements: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
            .wrap(item)
        }.toList
      )
    override val secrets: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.secrets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
            .wrap(item)
        }.toList
      )
    override val startTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.startTimeout())
      .map(value => value: Integer)
    override val stopTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTimeout())
      .map(value => value: Integer)
    override val systemControls: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.systemControls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
            .wrap(item)
        }.toList
      )
    override val ulimits: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.ulimits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
            .wrap(item)
        }.toList
      )
    override val user: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumesFrom: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.volumesFrom())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
            .wrap(item)
        }.toList
      )
    override val workingDirectory: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingDirectory())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly =
    new Wrapper(impl)
}
