package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsClusterDetails(
    clusterArn: Optional[NonEmptyString] = Optional.Absent,
    activeServicesCount: Optional[Integer] = Optional.Absent,
    capacityProviders: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    clusterSettings: Optional[
      Iterable[zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails]
    ] = Optional.Absent,
    configuration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails
    ] = Optional.Absent,
    defaultCapacityProviderStrategy: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
    ]] = Optional.Absent,
    clusterName: Optional[NonEmptyString] = Optional.Absent,
    registeredContainerInstancesCount: Optional[Integer] = Optional.Absent,
    runningTasksCount: Optional[Integer] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails = {
    import AwsEcsClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
      .builder()
      .optionallyWith(
        clusterArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        activeServicesCount.map(value => value: java.lang.Integer)
      )(_.activeServicesCount)
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        clusterSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSettings)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultCapacityProviderStrategy)
      .optionallyWith(
        clusterName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(
        registeredContainerInstancesCount.map(value => value: java.lang.Integer)
      )(_.registeredContainerInstancesCount)
      .optionallyWith(runningTasksCount.map(value => value: java.lang.Integer))(
        _.runningTasksCount
      )
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsClusterDetails.wrap(buildAwsValue())
}
object AwsEcsClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsClusterDetails =
      zio.aws.securityhub.model.AwsEcsClusterDetails(
        clusterArn.map(value => value),
        activeServicesCount.map(value => value),
        capacityProviders.map(value => value),
        clusterSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterName.map(value => value),
        registeredContainerInstancesCount.map(value => value),
        runningTasksCount.map(value => value),
        status.map(value => value)
      )
    def clusterArn: Optional[NonEmptyString]
    def activeServicesCount: Optional[Integer]
    def capacityProviders: Optional[List[NonEmptyString]]
    def clusterSettings: Optional[List[
      zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails.ReadOnly
    ]]
    def configuration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly
    ]
    def defaultCapacityProviderStrategy: Optional[List[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly
    ]]
    def clusterName: Optional[NonEmptyString]
    def registeredContainerInstancesCount: Optional[Integer]
    def runningTasksCount: Optional[Integer]
    def status: Optional[NonEmptyString]
    def getClusterArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getActiveServicesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("activeServicesCount", activeServicesCount)
    def getCapacityProviders: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getClusterSettings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterSettings", clusterSettings)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDefaultCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "defaultCapacityProviderStrategy",
      defaultCapacityProviderStrategy
    )
    def getClusterName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getRegisteredContainerInstancesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "registeredContainerInstancesCount",
        registeredContainerInstancesCount
      )
    def getRunningTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningTasksCount", runningTasksCount)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
  ) extends zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly {
    override val clusterArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val activeServicesCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.activeServicesCount())
      .map(value => value: Integer)
    override val capacityProviders: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProviders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val clusterSettings: Optional[List[
      zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails
            .wrap(item)
        }.toList
      )
    override val configuration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.wrap(value)
      )
    override val defaultCapacityProviderStrategy: Optional[List[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultCapacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
            .wrap(item)
        }.toList
      )
    override val clusterName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val registeredContainerInstancesCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredContainerInstancesCount())
        .map(value => value: Integer)
    override val runningTasksCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningTasksCount())
      .map(value => value: Integer)
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
  ): zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly = new Wrapper(impl)
}
