package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails(
    max: Optional[Double] = Optional.Absent,
    min: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails = {
    import AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
      .builder()
      .optionallyWith(max.map(value => value: java.lang.Double))(_.max)
      .optionallyWith(min.map(value => value: java.lang.Double))(_.min)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails(
          max.map(value => value),
          min.map(value => value)
        )
    def max: Optional[Double]
    def min: Optional[Double]
    def getMax: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("max", max)
    def getMin: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("min", min)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.ReadOnly {
    override val max: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Double)
    override val min: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.ReadOnly =
    new Wrapper(impl)
}
